from ml_collections import ConfigDict

from configs import cql_config


def get_config(updates=None):
    config = cql_config.get_config()

    config.critic_ensemble_size = 10
    config.critic_subsample_size = 2

    config.policy_network_kwargs.use_layer_norm = True
    config.critic_network_kwargs.use_layer_norm = True
    config.use_td_loss = True  # set this to False to essentially do BC
    config.use_calql = False
    config.online_cql_alpha = 0.0

    if updates is not None:
        config.update(ConfigDict(updates).copy_and_resolve_references())
    return config
